// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Support functions for Tsc.
//...........................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include "Tscmsg.h"
#include <htmlhelp.h>
#include <lmcons.h>
#include <CommDlg.h>
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD		dwStringSafeFlag;
extern	LPTSTR		lpszNA;
extern	HINSTANCE	hInst;
extern	HWND		hDialogModeLess;
extern	HWND		hDlgModeLess1;
extern	HWND		hDlgCurrent;
extern	HWND		hStatusBar;
extern	NUMBERFMT	nFormatInfo;
extern	HWND		hMainWindow;
extern	LPTSTR		lpszHelpFile;
extern	LPCSTR		lpContextHelp;
extern	LPDWORD		lpdwPadHelp;
extern	BOOL		bLogo;
extern	TCHAR		szPreviousSourceDir[MAX_PATH];
extern	TCHAR		szPreviousDestinationDir[MAX_PATH];
extern	DWORD		dwShellMajor;
extern	DWORD		dwShellMinor;
extern	DWORD		dwSlwapiMajor;
extern	DWORD		dwSlwapiMinor;
extern	HACCEL		hAccel;
extern	BOOL		bWin2000OrGreater;
extern	TCHAR		szPreviousEncFiles[MAX_PATH];
extern	CONFIG		cfg;
extern	TCHAR		szCfgFile[MAX_PATH];
extern	BOOL		bFirstTimeRead;

#define	Crc32Poly						0xedb88320

// Pointer for the crc32 table.
//.............................
LPBYTE		lpCrc32Table;

// Hold the pointer to a name of an icon in the resources.
//........................................................
LPCTSTR		lpIconPointer;

// Ending address in the SearchFor function.
//..........................................
LPBYTE		lpSearchEDI;

// Handle for the keyboard and mouse hook procedures.
//...................................................
HHOOK		hHook;
HHOOK		hMouseHook;

// Set if we want to trap the tab key.
//....................................
BOOL		bTrapTheTabKey = TRUE;

// Message box parameters structure for the MessageBoxProc
// function.
//........................................................
MSGBOXPARAMS mbParams;

// Message box strings for system sounds.
//.......................................
LPCTSTR		lpSystemHand = "SystemHand";
LPCTSTR		lpSystemAsterisk = "SystemAsterisk";
LPCTSTR		lpSystemQuestion = "SystemQuestion";
LPCTSTR		lpSystemExclamation = "SystemExclamation";
LPCTSTR		lpSystemDefault = "SystemDefault";

// Skip check counter for the CheckforMessages procedure.
//.......................................................
int			iSkipCounter;
int			iInitialSkipValue;

// Hours, minutes, and seconds for the 1 second timer.
//....................................................
DWORD		dwElapHours;
DWORD		dwElapMinutes;
DWORD		dwElapSeconds;
TCHAR		szElapsedTime[20];
TCHAR		szTimeFormat[] = "Elapsed Time: %02d%s%02d%s%02d";
TCHAR		TimeSep[10];

// Contains the help topic number for a help topic.
//.................................................
DWORD		dwHelpTopicNumber;

// Menu item info structure for our What's This popup menu.
//.........................................................
MENUITEMINFO	mii;
TCHAR			szWhatsThis[] = "&What's This?";

// Display name for SetDlgItemTextFmt function.
//...........................................
TCHAR			szDisplayName[520];

// CreateMyFile is a wrapper function for CreateFile. It returns a file
// handle if successful, or FALSE for cancel.
//.....................................................................
HANDLE CALLBACK CreateMyFile(LPTSTR FileName, DWORD Access, DWORD sMode,
							 LPSECURITY_ATTRIBUTES Sec_Attribs,
							 DWORD Create_Mode, DWORD Attribs, HANDLE TemplateFile) 
{
	HANDLE	hMyFile;
	int		iResult;

	// Go into a loop and if we have an error keep trying until
	// told to quit.
	//.........................................................
	while(TRUE)
	{
		hMyFile = CreateFile((LPCTSTR)FileName,Access,sMode,Sec_Attribs,
							  Create_Mode,Attribs,TemplateFile);

		// If we have an error display the error procedure messagebox.
		//............................................................
		if (hMyFile == INVALID_HANDLE_VALUE)
		{
			if (GetLastError() == ERROR_FILE_EXISTS && Create_Mode == CREATE_NEW)
			{
				// Ask if we want to delete the existing file and create this one.
				//................................................................
				SetLastError(IDS_REPLACEEXISITINGFILE);
				iResult = ErrorProcedure((LPTSTR)FileName,IDS_CREATE_OPEN,MB_OKCANCEL);
				if (iResult == IDCANCEL)
				{
					return(FALSE);
				}
				hMyFile = CreateFile((LPCTSTR)FileName,Access,sMode,Sec_Attribs,
									  CREATE_ALWAYS,Attribs,TemplateFile);
				if (hMyFile == INVALID_HANDLE_VALUE)
				{
					return(FALSE);
				}
				break;
			}
			else
			{
				iResult = ErrorProcedure((LPTSTR)FileName,IDS_CREATE_OPEN,MB_RETRYCANCEL);
				if (iResult == IDRETRY)
				{
					iResult = 0;
					continue;
				}
				else
				{
					return(FALSE);
				}
			}
		}
		else
		{
			break;
		}
	}
	return(hMyFile);
}

// ReadMyFile is a wrapper functions for ReadFile. It returns TRUE 
// if successful, and FALSE  for cancel.
//................................................................
BOOL CALLBACK ReadMyFile(LPTSTR FileName, HANDLE hFile, LPVOID lpvBuf,
						 DWORD BytesToRead, LPDWORD BytesRead, LPOVERLAPPED lpLapped)
{
	BOOL			bResult;
	int				iResult;
	LARGE_INTEGER	li;

	// First get our current position in the file so we can reset
	// it if we have to try again.
	//...........................................................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)FileName,hFile,li.QuadPart,FILE_CURRENT);
	if (li.QuadPart == -1)
	{
		return(FALSE);
	}
	// Go into a loop and if we have an error keep trying until
	// told to quit or abort.
	//.........................................................
	while(TRUE)
	{
		bResult = ReadFile(hFile,lpvBuf,BytesToRead,BytesRead,NULL);

		// Call the error procedure if we have an error.
		//..............................................
		if (bResult == FALSE)
		{
			iResult = ErrorProcedure((LPTSTR)FileName,IDS_READ,MB_RETRYCANCEL);
			if (iResult == IDRETRY)
			{
				iResult = 0;

				// Reset the file position in case it got changed.
				//...............................................
				li.QuadPart = SetMyFilePointer((LPTSTR) FileName,hFile,li.QuadPart,FILE_BEGIN);
				if (li.QuadPart == -1)
				{
					return(FALSE);
				}
				continue;
			}
			else
			{
				return(FALSE);
			}
		}
		else
		{
			break;
		}
	}
	return(TRUE);
}

// Flush the file buffers for the specified file to disk.
//.......................................................
BOOL FlushMyFile(LPTSTR FileName, HANDLE hFile)
{
	BOOL	bResult;

	bResult = FlushFileBuffers(hFile);

	// Call the error procedure if we have an error.
	//..............................................
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)FileName,IDS_FLUSHFILEBUFFER,MB_OK);
	}
	return(bResult);
}

// Copy a file to a new directory.
//................................
BOOL CopyMyFile(LPCTSTR lpExistingFile, LPCTSTR lpNewFile, BOOL bFailIfExists)
{
	BOOL	bResult;

	bResult = CopyFile((LPCTSTR)lpExistingFile,(LPCTSTR)lpNewFile,bFailIfExists);

	// Call the error procedure is we have an error.
	//..............................................
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)lpExistingFile,IDS_RENAMEFILE,MB_OK);
	}
	return(bResult);
}
		
// SetMyFilePointer sets or gets the file position asked for.
// It returns the file position in a LARGE_INTEGER structure.
// If it equals -1 there was an error, so cancel the operation.
// Handles huge files over 2 GBytes.
//.............................................................
__int64 CALLBACK SetMyFilePointer(LPTSTR FileName, HANDLE hFile,
								   __int64 DistanceToMove, DWORD Method)
{
	LARGE_INTEGER	li;
	int				iResult;

	// Keep tring until told to quit.
	//...............................
	while(TRUE)
	{
		li.QuadPart = DistanceToMove;
		li.LowPart = SetFilePointer(hFile,li.LowPart,&li.HighPart,Method);

		// Determine if we had an error or not.
		//.....................................
		if (li.LowPart == -1 && GetLastError() != NO_ERROR)
		{
			li.QuadPart = -1;
			iResult = ErrorProcedure((LPTSTR) FileName,IDS_SETFILEPOINTER,MB_RETRYCANCEL);
			if (iResult == IDRETRY)
			{
				iResult = 0;
				continue;
			}
			else
			{
				break;
			}
		}
		break;
	}
	return(li.QuadPart);
}

// Get the size of a file. Handles all file sizes. Returns -1 in a
// LARGE_INTEGER structure if there was an error.
//................................................................
__int64 GetMyFileSize(LPTSTR FileName, HANDLE hFile)
{
	ULARGE_INTEGER	li;
	int				iResult;

	// Get the size of the file.
	//..........................
	while(TRUE)
	{
		li.LowPart = GetFileSize(hFile,&li.HighPart);

		// Determine if we had an error or not.
		//.....................................
		if (li.LowPart == 0xffffffff && GetLastError() != NO_ERROR)
		{
			li.QuadPart = -1;
			iResult = ErrorProcedure((LPTSTR) FileName,IDS_GETFILESIZE,MB_RETRYCANCEL);
			if (iResult == IDRETRY)
			{
				iResult = 0;
				continue;
			}
			else
			{
				break;
			}
		}
		break;
	}
	return(li.QuadPart);
}

// WriteMyFile is a wrapper function for WriteFile. It returns TRUE
// if successful, and FALSE for cancel.
//.................................................................
BOOL CALLBACK WriteMyFile(LPTSTR FileName, HANDLE hFile, LPCVOID lpcBuf,
						  DWORD BytesToWrite, LPDWORD BytesWritten, LPOVERLAPPED lpLapped)
{
	BOOL			bResult;
	int				iResult;
	LARGE_INTEGER	li;
	DWORD			BytesWrote;

	// First get our current position in the file so we can reset
	// it if we have to try again.
	//...........................................................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)FileName,hFile,li.QuadPart,FILE_CURRENT);
	if (li.QuadPart == -1)
	{
		return(FALSE);
	}
	
	// Go into a loop and if we have an error keep trying until
	// told to quit or abort.
	//.........................................................
	while(TRUE)	
	{
		bResult = WriteFile(hFile,lpcBuf,BytesToWrite,BytesWritten,NULL);

		// Call the error procedure if we have an error.
		//..............................................
		if (bResult == FALSE)
		{
			iResult = ErrorProcedure((LPTSTR)FileName,IDS_WRITE,MB_RETRYCANCEL);
			if (iResult == IDRETRY)
			{
				iResult = 0;
				// Reset the file position in case it got changed.
				//...............................................
				li.QuadPart = SetMyFilePointer((LPTSTR) FileName,hFile,li.QuadPart,FILE_BEGIN);
				if (li.QuadPart == -1)
				{
					return(FALSE);
				}
				continue;
			}
			else
			{
				return(FALSE);
			}
		}
		// Check to make sure that the actual number of bytes
		// written matches the number of bytes to write.
		//...................................................
		BytesWrote = *BytesWritten;
		if (BytesToWrite != BytesWrote)
		{
			SetLastError(IDS_WRITENOTEQUAL);
			ErrorProcedure((LPTSTR)FileName,IDS_WRITE,MB_OK);
			return(FALSE);
		}
		else
		{
			break;
		}
	}
	return(TRUE);
}

// CloseMyHandle can be used to close any type of handle. Most of
// the time it will be used for files. If not for files, set file
// name to point to a string that says N/A or the type of object
// you are closing.
//...............................................................
BOOL CALLBACK CloseMyHandle(LPTSTR FileName, HANDLE hObject)
{
	BOOL	bResult;
	int		iResult;

	// Stay in a loop until successful or told to quit.
	//.................................................
	while(TRUE)
	{
		bResult = CloseHandle(hObject);
		if (!bResult)
		{
			iResult = ErrorProcedure((LPTSTR)FileName,IDS_CLOSE,MB_RETRYCANCEL);
			if (iResult == IDRETRY)
			{
				iResult = 0;
				continue;
			}
			else
			{
				return(FALSE);
			}
		}
		break;
	}
	return(TRUE);
}

// Delete the designated file. Return TRUE if successful,or
// FALSE is we have an error.
//.........................................................
BOOL CALLBACK DeleteMyFile(LPTSTR File)
{
	BOOL	bResult;
	int		iResult;

	// Stay in a loop until successful or told to quit.
	//.................................................
	while(TRUE)
	{
		bResult = DeleteFile((LPCTSTR)File);
		if (!bResult)
		{
			iResult = ErrorProcedure((LPTSTR)File,IDS_DELETE_FILE,MB_RETRYCANCEL);
			if (iResult == IDRETRY)
			{
				iResult = 0;
				continue;
			}
			else
			{
				return(FALSE);
			}
		}
		break;
	}
	return(TRUE);
}

// Compare two strings in memory.
// Returns 0 if the two are equal. 1 if destination is 
// larger than the source. -1 if destination is smaller
// than the source. 0 is the same as zero flag set. 1 is
// the same as carry flag set. -1 is the same as carry
// and zero flags clear.
//.....................................................
DWORD MpCompareStrings(LPBYTE lpSource, LPBYTE lpDestination, DWORD dwByteCount)
{
	DWORD dwResult = 0;

	if (dwByteCount)
	{
		__asm
		{
			mov		edi,lpDestination
			mov		esi,lpSource
			mov		ecx,dwByteCount
			repe	cmpsb
			jnz		L1
			mov		dwResult,0
			jmp		L3
		L1: jnc		L2
			mov		dwResult,1
			jmp		L3
		L2:	mov		dwResult,-1
		L3:
		}
	}
	return(dwResult);
}

// Initialize an OPENFILENAME Structure.
//......................................
VOID InitializeOFN(LPOPENFILENAME lpofn, DWORD dwInitialDir)
{
	// Setup the structure with some default values.
	//..............................................
	ZeroMemory((LPOPENFILENAME)lpofn,sizeof(OPENFILENAME));
	if (bWin2000OrGreater)
	{
		lpofn->lStructSize = sizeof(OPENFILENAME);
	}
	else
	{
		lpofn->lStructSize = OPENFILENAME_SIZE_VERSION_400;
	}
	lpofn->lpstrFileTitle = NULL;
	lpofn->nMaxFileTitle = 0;
	if (dwInitialDir & SAVE_SOURCE)
	{
		lpofn->lpstrInitialDir = (LPCTSTR)&szPreviousSourceDir;
	}
	else if (dwInitialDir & SAVE_DESTINATION)
	{
		lpofn->lpstrInitialDir = (LPCTSTR)&szPreviousDestinationDir;
	}
	else if (dwInitialDir & SAVE_OTPKEYFILES)
	{
		lpofn->lpstrInitialDir = (LPCTSTR)&cfg.szPreviousOTPKeyFiles;
	}
	else if (dwInitialDir & SAVE_TOTPFILES)
	{
		lpofn->lpstrInitialDir = (LPCTSTR)&cfg.szPreviousTOTPFiles;
	}
	else if (dwInitialDir & SAVE_DIARYFILES)
	{
		lpofn->lpstrInitialDir = (LPCTSTR)&cfg.szPreviousDiaryFiles;
	}
	else if (dwInitialDir & SAVE_ENCRYPT_DIR)
	{
		lpofn->lpstrInitialDir = (LPCTSTR)&cfg.szPreviousEncFiles;
	}
	lpofn->lCustData = 0;
}

// Allocate and lock in the memory requested. Return
// pointer to memory if successful, else return 0.
//..................................................
LPVOID AllocateMemory(DWORD dwMemRequested)
{
	LPVOID lpMemPtr;
		
	lpMemPtr = GlobalAlloc(GPTR,dwMemRequested);
	
	// See if we had an error.
	//........................
	if (!lpMemPtr)
	{
		ErrorProcedure((LPTSTR)lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
	}
	return(lpMemPtr);
}

// Deallocate memory. When memory is allocated with the
// GMEM_FIXED flag, the handle equals the pointer.
//......................................................
BOOL DeallocateMemory(HGLOBAL hMem)
{
	BOOL bResult = TRUE;

	if (GlobalFree(hMem))
	{
		ErrorProcedure((LPTSTR)lpszNA,IDS_DEALLOCATEMEM,MB_OK);
		bResult = FALSE;
	}
	return(bResult);
}

// Set the selected icon in all dialog box caption bars.
// lpIconPointer must be initialized before calling this
// function.
//......................................................
VOID SetMyIcon(HWND hDlg)
{
	HICON hIcon;

	// Load the image and set the icon.
	//.................................
	hIcon = LoadImage(hInst,lpIconPointer,IMAGE_ICON,16,16,LR_SHARED);
	if (hIcon)
	{
		SendMessage(hDlg,WM_SETICON,ICON_SMALL,(LPARAM)hIcon);
	}
}

// Create an up down control, a spin box, in a dialog box.
//........................................................
HWND CreateMySpinBox(DWORD dwStyles, int x, int y, int width, int height,
					 HWND hWndParent, int iControlID, HWND hWndBuddy,
					 int iMax, int iMin, int iInitial)
{
	HWND hSpinBox;

	// Create the spin box.
	//.....................
	hSpinBox = CreateWindowEx(0L,UPDOWN_CLASS,"",
							  WS_CHILD | WS_VISIBLE | WS_BORDER | dwStyles,
							  x,y,width,height,hWndParent,(HMENU)iControlID,hInst,NULL);
	if (!hSpinBox)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
	}
	else
	{
		// Set the buddy control.
		//.......................
		SendMessage(hSpinBox,UDM_SETBUDDY,(WPARAM)hWndBuddy,0L);

		// Set the range of the spin box.
		//...............................
		SendMessage(hSpinBox,UDM_SETRANGE32,iMin,iMax);

		// Set the initial value of the spin box.
		//.......................................
		SendMessage(hSpinBox,UDM_SETPOS,0L,MAKELONG(iInitial,0L));
	}
	return(hSpinBox);
}

// DateToJulian converts a given year, month, and day to a
// julian day number, which is returned in eax.
//........................................................
DWORD DateToJulian(LPSYSTEMTIME lpst)
{
	DWORD dwYear;
	DWORD dwMonth;
	DWORD dwDay;

	dwYear = MAKELONG(lpst->wYear,0);
	dwMonth = MAKELONG(lpst->wMonth,0);
	dwDay = MAKELONG(lpst->wDay,0);

	__asm
	{
		mov		eax,dwYear
		mov		ecx,dwDay
		mov		edx,dwMonth
		cmp		edx,2
		jbe		L1
		sub		edx,3
		jmp		L2
	L1:	add		edx,9
		sub		eax,1
	L2:	push	ecx			// day
		push	edx			// month
		xor		edx,edx
		mov		ecx,100
		div		ecx			// year/100
		push	edx			// remainder
		xor		edx,edx
		mov		ecx,146097
		mul		ecx
		shr		eax,2		// a = 146097 * (year/100)/4
		mov		edi,eax		// edi = a
		pop		eax			// remainder
		xor		edx,edx
		mov		ecx,1461
		mul		ecx
		shr		eax,2		// b = 1461 * (year mod 100)/4
		add		edi,eax		// edi = a + b
		pop		eax			// month
		xor		edx,edx
		mov		ecx,153
		mul		ecx			// c = (153 * month)/5
		add		eax,2
		xor		edx,edx
		mov		ecx,5
		div		ecx
		pop		ecx			// day
		add		eax,ecx
		add		eax,1721119
		add		eax,edi		// eax = a + b + c = julian day
	}
}

// JulianToDate converts an astronomical julian day number into
// a conventional date in a SYSTEMTIME structure.
//.............................................................
VOID JulianToDate(LPSYSTEMTIME lpst, DWORD JulianDay)
{
	DWORD dwMonth;
	DWORD dwDay;
	DWORD dwYear;

	__asm
	{
		mov		eax,JulianDay
		shl		eax,2			// X = (4 * JDN) - 6884477
		sub		eax,6884477
		xor		edx,edx
		mov		ecx,146097		// Y = (X/146097) * 100
		div		ecx
		push	edx				// Save remainder
		mov		ecx,100
		xor		edx,edx
		mul		ecx
		mov		ebx,eax			// Y to ebx
		pop		eax				// D = (X mod 146097)/4
		shr		eax,2			// D in eax
		shl		eax,2			// X = 4 * D + 3
		add		eax,3			// 2nd X in eax
		xor		edx,edx
		mov		ecx,1461
		div		ecx				// Y = (X/1461) + 1st Y
		add		eax,ebx
		push	eax				// 2nd Y on stack
		shr		edx,2			// D = (X mod 1461)/4 + 1
		add		edx,1
		push	edx				// 2nd D on stack
		shl		edx,2			// X = 5 * D - 3
		pop		ecx				// 2nd D from stack
		add		edx,ecx
		sub		edx,3
		mov		eax,edx			// 3rd X to eax
		xor		edx,edx
		mov		ecx,153			// M = x/153 + 1
		div		ecx
		inc		eax
		push	eax				// M on stack
		cmp		eax,11
		jae		L1
		add		eax,2
		jmp		L2
	L1:	sub		eax,10
	L2: mov		dwMonth,eax
		mov		eax,edx			// D = (X mod 153)/5 + 1
		xor		edx,edx
		mov		ecx,5
		div		ecx
		inc		eax
		mov		dwDay,eax
		xor		edx,edx
		pop		eax				// M from stack
		mov		ecx,11			// Y = Y + M/11
		div		ecx
		pop		edx				// Y from stack
		add		eax,edx
		mov		dwYear,eax
	}
	// Return the day, month, and year in a SYSTEMTIME structure.
	//...........................................................
	lpst->wMonth = LOWORD(dwMonth);
	lpst->wDay = LOWORD(dwDay);
	lpst->wYear = LOWORD(dwYear);
}

// Given the Julian Day Number return the day of the week.
// 0 = Sunday, 1 = Monday, etc.
//........................................................
WORD DayOfWeek(DWORD dwJulianDay)
{
	WORD	wDayOfWeek;

	__asm
	{
		mov		eax,dwJulianDay
		xor		edx,edx
		mov		ecx,7h
		div		ecx
		
		// Change the day of week number to be compatible
		// with the Windows SYSTIME structure.
		//...............................................
		inc		edx
		cmp		edx,7h
		jne		L1
		mov		edx,0h
	L1:	mov		eax,edx
		mov		wDayOfWeek,ax
	}
	return(wDayOfWeek);
}

// Return a GMT or local timestamp based on the number of seconds
// from 1 Jan. 1970.
//...............................................................
__int64 GetTimestamp(BOOL bGmt)
{
	ULARGE_INTEGER		li;
	SYSTEMTIME			stGmt;
	DWORD				dwSysTimeJD;
	DWORD				dwHours1;
	DWORD				dwMinutes1;
	DWORD				dwSeconds1;

	li.QuadPart = 0;

	// Get the system time which includes the date and time based
	// on GMT time.
	//...........................................................
	if (bGmt)
	{
		GetSystemTime(&stGmt);
	}
	else
	{
		GetLocalTime(&stGmt);
	}
	dwHours1 = MAKELONG(stGmt.wHour,0);
	dwMinutes1 = MAKELONG(stGmt.wMinute,0);
	dwSeconds1 = MAKELONG(stGmt.wSecond,0);

	// Get the Julian Day number of the GMT date.
	//...........................................
	dwSysTimeJD = DateToJulian(&stGmt);

	// Subtract the Julian Day number for 1 Jan. 1970.
	//................................................
	dwSysTimeJD -= JD_1_JAN_1970;

	__asm
	{
		push	edi
		xor		edx,edx
		mov		eax,dwSysTimeJD
		mov		ecx,SECS_PER_DAY
		mul		ecx
		mov		ebx,eax
		mov		edi,edx				// edi:ebx
		add		ebx,dwSeconds1
		adc		edi,0				// edi:ebx

		xor		edx,edx
		mov		eax,dwMinutes1
		mov		ecx,60				// seconds per minute
		mul		ecx
		add		ebx,eax
		adc		edi,edx

		xor		edx,edx
		mov		eax,dwHours1
		mov		ecx,SECS_PER_HOUR
		mul		ecx
		add		eax,ebx
		adc		edx,edi
		and		edx,0x7f
		pop		edi
	}
}

// Trap the tab key with the keyboard hook procedure.
//...................................................
LRESULT CALLBACK TrapTabKey(int nCode, WPARAM wParam, LPARAM lParam)
{
	if (nCode == HC_ACTION)
	{
		if (wParam == VK_TAB && bTrapTheTabKey)
		{
			return(TRUE);
		}
		else
		{
			return(0);
		}
	}
	else
	{
		return(CallNextHookEx(hHook,nCode,wParam,lParam));
	}
}

// Trap mouse input to keep from tabbing or moving to controls in
// a dialog box and to keep the focus on the cancel button in the
// dialog box.
//...............................................................
LRESULT CALLBACK TrapMouseInput(int nCode, WPARAM wParam, LPARAM lParam)
{
	LPMOUSEHOOKSTRUCT	lpMouseHookStruct;
	HWND				hCancel;
	HWND				hChild;
	HWND				hParent;
	
	hCancel = GetDlgItem(hDlgCurrent,IDCANCEL);
	lpMouseHookStruct = (LPVOID)lParam;
	hChild = lpMouseHookStruct->hwnd;

	// If this handle in the main window, process the message.
	//........................................................
	if (hChild == hMainWindow)
	{
		return (0);
	}

	if (hChild != hDlgCurrent)
	{
		hParent = GetParent(hChild);
	}

	if (nCode == HC_ACTION)
	{
		if (wParam == WM_LBUTTONDOWN)
		{
			if (hChild == hCancel)
			{
				return(0);
			}
			if (hChild == hDlgCurrent)
			{
				return(0);
			}
			if (hParent == hDlgCurrent)
			{
				return(1);
			}
			else
			{
				return(0);
			}
		}
		else
		{
			return(0);
		}
	}
	else
	{
		return(CallNextHookEx(hMouseHook,nCode,wParam,lParam));
	}
}

// Check for messages while a modeless dialog box is displayed and 
// we are doing lengthly processing.
//................................................................
VOID CheckForMessages()
{
	MSG		msg;

	if (iSkipCounter <= 0)
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			if (!TranslateAccelerator(hMainWindow,hAccel,&msg))
			{
				if (!IsDialogMessage(hDlgCurrent, &msg))
				{
					if (!HtmlHelp(NULL,NULL,HH_PRETRANSLATEMESSAGE,(DWORD)&msg))
					{	
						TranslateMessage(&msg); 
						DispatchMessage(&msg);  
					}
				}
			}
		}
		iSkipCounter = iInitialSkipValue;
	}
	iSkipCounter--;
}

// Empty the message que makes sure all messages are processed
// before we continue with the program.
//............................................................
VOID EmptyTheMessageQue()
{
	MSG		msg;

	while(TRUE)
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			if (!TranslateAccelerator(hMainWindow,hAccel,&msg))
			{
				if (hDlgCurrent == NULL || !IsDialogMessage(hDlgCurrent,&msg))
				{
					if (!HtmlHelp(NULL,NULL,HH_PRETRANSLATEMESSAGE,(DWORD)&msg))
					{
						TranslateMessage(&msg); 
						DispatchMessage(&msg);  
					}
				}
			}
		}
		else
		{
			break;
		}
	}
}

// 1 second timer callback function. Used to display elapsed time
// on the status bar.
//...............................................................
VOID CALLBACK My1SecondTimer(HWND hWnd, UINT uTimerMsg, UINT uTimerID, DWORD dwTime)
{
	if (uTimerID == MY_TIMER)
	{
		dwElapSeconds++;
		if (dwElapSeconds == 60)
		{
			dwElapSeconds = 0;
			dwElapMinutes++;

			if (dwElapMinutes == 60)
			{
				dwElapMinutes = 0;
				dwElapHours++;
			}
		}
		// Format and display the time.
		//.............................
		StringCbPrintf(szElapsedTime,sizeof(szElapsedTime),szTimeFormat,dwElapHours,
					   TimeSep,dwElapMinutes,TimeSep,dwElapSeconds);
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szElapsedTime);
	}
}

// Display the Elapsed Timer with a zero value.
//.............................................
VOID DisplayZeroTimer()
{
	// Format and display the time.
	//.............................
	StringCbPrintf(szElapsedTime,sizeof(szElapsedTime),szTimeFormat,dwElapHours,TimeSep,
				   dwElapMinutes,TimeSep,dwElapSeconds);
	SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szElapsedTime);
}

// Flash task bar icon entry for attention at 1 second intervals.
//...............................................................
VOID CALLBACK FlashIconTimer(HWND hWnd, UINT uTimerMsg, UINT uTimerID, DWORD dwTime)
{
	if (uTimerID == FLASH_TIMER)
	{
		FlashWindow(hMainWindow,TRUE);
	}
}

// Flashes the task bar icon, if it is minimized, until we restore it.
//....................................................................
VOID FlashMyIcon(BOOL bNotifyMe)
{
	UINT uFlashTimer;

	if (IsIconic(hMainWindow))
	{
		NotifyMe();

		uFlashTimer = SetTimer(hMainWindow,FLASH_TIMER,1000,(TIMERPROC)FlashIconTimer);
		if (uFlashTimer)
		{
			while (TRUE)
			{
				CheckForMessages();

				if (!IsIconic(hMainWindow))
				{
					KillTimer(hMainWindow,FLASH_TIMER);
					break;
				}
			}
		}
	}
	else
	{
		if (bNotifyMe)
		{
			NotifyMe();
		}
	}
}

// Format a number for output. Returns the formated string.
//.........................................................
VOID FormatMyNumber(DWORD dwNumber, LPTSTR lpOutPut, DWORD dwSize)
{
	TCHAR	cBuffer[24];

	StringCbPrintf(cBuffer,sizeof(cBuffer),TEXT("%d"),dwNumber);
	GetNumberFormat(LOCALE_USER_DEFAULT,0,cBuffer,&nFormatInfo,lpOutPut,dwSize);
}

// Swap two fields in memory.
//...........................
VOID SwapOps(LPBYTE lpOperand1, LPBYTE lpOperand2, DWORD dwByteCount)
{
	__asm
	{
		mov		esi,lpOperand1
		mov		edi,lpOperand2
		mov		ecx,dwByteCount
	L1:	mov		al,byte ptr [edi]
		movsb
		mov		byte ptr [esi-1],al
		dec		ecx
		jnz		L1
	}
}

// MessageBoxProc returns the result of the MessageBoxIndirect
// Function. If you are going to use one of your own icons uStyle
// must include MB_USERICON and you have to provide a pointer to
// your icon in the resourse file. MB_USERICON does not seem to
// work with Windows XP.
//...............................................................
int MessageBoxProc(HWND hWin, UINT uTitle, UINT uText, UINT uStyle, UINT uBeep, LPCTSTR lpIcon)
{
	LPCTSTR		lpSound;

	FlashMyIcon(FALSE);

	// Setup the rest of the MSGBOXPARAMS structure.
	//..............................................
	mbParams.hwndOwner = hWin;
	mbParams.lpszCaption = (LPCTSTR)uTitle;
	mbParams.lpszText = (LPCTSTR)uText;
	mbParams.dwStyle = uStyle;
	mbParams.lpszIcon = lpIcon;

	if (uBeep)
	{
		lpSound = lpSystemDefault;

		if (uBeep == MB_ICONHAND)
		{
			lpSound = lpSystemHand;
		}
		else if (uBeep == MB_ICONQUESTION)
		{
			lpSound = lpSystemQuestion;
		}
		else if (uBeep == MB_ICONASTERISK)
		{
			lpSound = lpSystemAsterisk;
		}
		else if (uBeep == MB_ICONEXCLAMATION)
		{
			lpSound = lpSystemExclamation;
		}
		// Play our sound.
		//................
		if (cfg.dwPlaySounds)
		{
			PlaySound(lpSound,NULL,SND_ALIAS | SND_ASYNC);
		}
	}
	return(MessageBoxIndirect(&mbParams));
}

// Sets up our MSGBOXPARAMS structure with some default values.
// dwLangId must be specified. The others may be null. The call
// back function is only used for context sensitive help.
//.............................................................
VOID MessageBoxSetup(DWORD dwLangId, MSGBOXCALLBACK lpfnMsgBoxCallBack, DWORD dwContextHelpId)
{
	mbParams.cbSize = sizeof(MSGBOXPARAMS);
	mbParams.hInstance = hInst;
	mbParams.lpfnMsgBoxCallback = lpfnMsgBoxCallBack;
	mbParams.dwLanguageId = dwLangId;
	mbParams.dwContextHelpId = dwContextHelpId;
}

// Change the help topic. Returns the old topic number
// which should be replaced at the end of a procedure.
//.....................................................
DWORD ChangeHelpTopic(DWORD dwNewHelpTopic)
{
	DWORD	dwOldHelpTopic;

	dwOldHelpTopic = dwHelpTopicNumber;
	dwHelpTopicNumber = dwNewHelpTopic;
	return(dwOldHelpTopic);
}

// Displays context sensitive help topics for the program.
// dwHelpTopicNumber is a global variable that contains
// the topic number.
//........................................................
VOID DisplayMyHelp(HWND hWnd)
{
	HWND hHtmlHelpResult;

	hHtmlHelpResult = HtmlHelp(hWnd,lpszHelpFile,HH_HELP_CONTEXT,dwHelpTopicNumber);

	if (!hHtmlHelpResult)
	{
		MessageBoxProc(hWnd,IDS_PROGRAM_ERROR,IDS_NO_HTML_HELP,
					   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
	}
	EmptyTheMessageQue();
}

// Perform a shell sort on a table of structured data. Sort in any
// direction and on signed data (with restrictions). If the sort
// structure is setup correctly, it is possible to sort on multiple
// fields in a record in one sort operation.
//.................................................................
VOID ShellSort(LPBYTE lpTable, DWORD dwRecordCount, LPSORT_TEMPLATE lpSortParameters, 
					  DWORD dwDirection)
{
	DWORD		dwTempEDX;
	DWORD		dwTempEBX;
	DWORD		dwCenter;
	DWORD		dwBoundry;
	DWORD		dwDupBoundry;
	DWORD		dwFlag;
	DWORD		dwIndexB;
	DWORD		dwIndexC;
	LPBYTE		lpRecordB;
	LPBYTE		lpRecordC;
	DWORD		dwRecordSize;
	int			iCompareResult;
	BOOL		bSwapFlag;
	BYTE		Above;
	BYTE		Below;
	BYTE		Signed;

	// Setup a local record size variable..
	//.....................................
	dwRecordSize = lpSortParameters->RECORD_SIZE;

	// If we have records to sort, sort them.
	//.......................................
	if (dwRecordCount >= 2)
	{
		__asm
		{
			// Center = record count / 2.
			//...........................
			mov		eax,dwRecordCount
			shr		eax,1
			mov		dwCenter,eax

			// Make sure - process low to high addresses.
			//...........................................
			cld							
		}
		// When center equals 0 we are done with the sort.
		//................................................
		while(dwCenter != 0)
		{
			// Boundry = record count - center.
			//.................................
			__asm
			{
				mov		eax,dwRecordCount
				sub		eax,dwCenter
				mov		dwBoundry,eax
			L1:	mov		dwFlag,0

				// dwIndexB = table offset.
				// dwIndexC = table offset + (dwCenter * size of entry)
				//.....................................................
				mov		eax,lpTable
				mov		dwIndexB,eax
				mov		dwIndexC,eax
				mov		eax,dwCenter
				mov		ecx,dwRecordSize
				mul		ecx
				add		dwIndexC,eax
				mov		bSwapFlag,FALSE
				mov		ecx,dwBoundry
				mov		dwDupBoundry,ecx
			}
			while(dwDupBoundry != 0)
			{
				__asm
				{
					// Start sorting the record with the first set
					// of sort parameters.
					//............................................
					mov		edx,lpSortParameters
					xor		ebx,ebx
					mov		dwTempEDX,edx
					mov		dwTempEBX,ebx
				}
				while(TRUE)
				{
					__asm
					{
						mov		edx,dwTempEDX
						mov		ebx,dwTempEBX

						// Compare the designated field in the records.
						//.............................................
						mov		esi,dwIndexB	// Bottom index.
						mov		edi,dwIndexC	// Center index.

						// Point to the part of the record to compare.
						//............................................
						add		esi,dword ptr [edx][ebx].COMPARE_OFFSET
						add		edi,dword ptr [edx][ebx].COMPARE_OFFSET
						mov		lpRecordB,esi
						mov		lpRecordC,edi

						// Size of the data to compare. If bytes, the
						// number of bytes; if words, the number of words;
						// if dwords, the number of dwords.
						//................................................
						mov		ecx,dword ptr [edx][ebx].COMPARE_SIZE

						// See if we are doing a signed comparison.
						//.........................................
						btr		dword ptr [edx][ebx].TYPE_SORT,7
						setc	Signed

						// Setup the direction for the comparision.
						//.........................................
						cmp		dword ptr [edx][ebx].COMPARE_DIRECTION,BACKWARD
						jne		L2

						// Comparision is performed backwards - high address to low.
						//..........................................................
						std

						// Compare bytes.
						//...............
					L2:	cmp		dword ptr [edx][ebx].TYPE_SORT,SORT_BYTES
						jne		L3
						repe	cmpsb
						jmp		L5
						
						// Compare words.
						//...............
					L3:	cmp		dword ptr [edx][ebx].TYPE_SORT,SORT_WORDS
						jne		L4
						rep		cmpsw
						jmp		L5

						// Compare dwords.
						//................
					L4:	cmp		dword ptr [edx][ebx].TYPE_SORT,SORT_DWORDS
						jne		L7					// Default to sort strings.
						repe	cmpsd
						
						// Make sure - reset direction to low to high address.
						//....................................................
					L5:	cld			
						
						// Set the flags depending on if we sorted signed
						// fields or not.
						//...............................................
						pushfd
						cmp		Signed,1
						je		L6
						popfd
						seta	Above
						setb	Below
						jmp		L8
					L6:	popfd
						setg	Above
						setl	Below

						// Reset the signed field in the TYPE_SORT
						// parameter for the next record.
						//........................................
						bts		dword ptr [edx][ebx].TYPE_SORT,7
						jmp		L8

						// Save all of our registeres.
						//............................
					L7:	pushad
					}
					// Compare strings using user default settings.
					//.............................................
					iCompareResult = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
												   lpRecordB,-1,lpRecordC,-1);
					Above = 0;
					Below = 0;
					if (iCompareResult == CSTR_LESS_THAN)
					{
						Below = 1;
					}
					else if (iCompareResult == CSTR_GREATER_THAN)
					{
						Above = 1;
					}

					__asm
					{
						popad

						// Break if the fields are not equal.
						//...................................
						cmp		iCompareResult,CSTR_EQUAL
					L8:	jne		CheckSwap

						// Break if the fields are equal and we have
						// no more fields to sort on; else continue
						// sorting the record on the next field.
						//...........................................
						add		ebx,20			// Size of sort structure.
						mov		dwTempEBX,ebx
						cmp		dword ptr [edx][ebx].TYPE_SORT,SORT_END
						je		CheckSwap
					}
				}	// while TRUE

				// See if we have to swap the records.
				// Swap entries depending on the result of
				// the comparison and sort direction. The
				// entries will not be swaped if they are
				// equal.
				//........................................
			  CheckSwap:
				if (((dwDirection == ASCENDING) && Above) || 
				   ((dwDirection == DESCENDING) && Below))
				{	
					__asm
					{
						mov		esi,dwIndexB
						mov		edi,dwIndexC
						mov		ecx,dwRecordSize

						// Swap the records.
						//..................
					SwapRecords:
						mov		al,byte ptr [edi]
						movsb
						mov		byte ptr [esi-1],al
						dec		ecx
						jnz		SwapRecords

						// We had a swap.
						//...............
						mov		bSwapFlag,TRUE
					}
				}
				// Setup the next records in dwIndexB and dwIndexC
				// to compare.
				//................................................
				__asm
				{
					mov		eax,dwRecordSize
					add		dwIndexB,eax
					add		dwIndexC,eax
					inc		dwFlag
					dec		dwDupBoundry
				}
			}	// while dwDupBoundry != 0

			// Determine boundries for the next round of sorts.
			//.................................................
			__asm
			{
				// If dwFlag - dwCenter is equal to, or less than 0,
				// we are done with this section. Setup a new center.
				//...................................................
				mov		eax,dwFlag
				sub		eax,dwCenter
				jbe		L9

				// If we had a swap make boundry = flag - center.
				//...............................................
				cmp		bSwapFlag,TRUE
				jne		L9

				// Go back and sort the new boundry area.
				//.......................................
				mov		dwBoundry,eax
				jmp		L1

				// We did not have a swap or dwFlag = dwCenter.
				// Setup a new center.
				//.............................................
			L9:	shr		dwCenter,1
			}
		}	// while dwCenter != 0
	}	// if dwRecordCount >= 2
}

// SortMyFile determines if a file can be sorted in memory or not
// and calls the correct function to sort the file based on this
// determination.
//...............................................................
BOOL SortMyFile(LPTSTR FileName, HANDLE hFile, DWORD dwHeaderBytes,
					  LPSORT_TEMPLATE lpSortParameters, DWORD dwDirection)
{
	ULARGE_INTEGER	li;
	LARGE_INTEGER	liHdrBytes;
	DWORD			dwNumberOfRecords;
	DWORD			dwFileSize;
	LPBYTE			lpFileBuffer = 0;
	BOOL			bResult = FALSE;

	liHdrBytes.QuadPart = 0;
	liHdrBytes.LowPart = dwHeaderBytes;
	
	// Get the file size and return if we had an error.
	//.................................................
	li.QuadPart = GetMyFileSize(FileName,hFile);
	if (li.QuadPart == -1)
	{
		goto SortEnd;
	}
	// We only handle file sizes up to 4 Gigabytes long.
	//..................................................
	if (li.QuadPart > 0xffffffff)
	{
		MessageBoxProc(hMainWindow,IDS_PROGRAMLIMIT,IDS_FILETOOBIG,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto SortEnd;
	}
	// Determine the size of the file minus the header bytes and then
	// calculate the number of records in the file.
	//...............................................................
	dwFileSize = (li.LowPart - dwHeaderBytes);
	dwNumberOfRecords = (dwFileSize/lpSortParameters->RECORD_SIZE);

	// Position the file pointer to point to the first record
	// in the file.
	//.......................................................
	li.QuadPart = SetMyFilePointer(FileName,hFile,liHdrBytes.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto SortEnd;
	}
	// Allocate the memory for the file.
	//..................................
	lpFileBuffer = GlobalAlloc(GPTR,dwFileSize);

	// If the error is other than not enough memory display an error
	// message and exit.
	//..............................................................
	if (!lpFileBuffer)
	{
		if (GetLastError() != ERROR_NOT_ENOUGH_MEMORY)
		{
			ErrorProcedure((LPTSTR) lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
			goto SortEnd;
		}
		else
		{
			// Not enough memory to sort the file in memory so sort
			// it on disk.
			//.....................................................
			bResult = SortFileOnDisk(FileName,hFile,lpSortParameters,dwNumberOfRecords,
										   dwFileSize,dwHeaderBytes,dwDirection);
		}
	}
	else
	{
		// We have enough memory to sort the file in memory.
		//..................................................
		bResult = SortFileInMemory(FileName,hFile,lpFileBuffer,lpSortParameters,
										 dwNumberOfRecords,dwFileSize,dwHeaderBytes,
										 dwDirection);
		DeallocateMemory(lpFileBuffer);
	}

	SortEnd:
	return(bResult);
}

// Sort a file in memory if we have enough. Returns TRUE if
// successful, else FALSE. Sort in any direction.
//............................................................
BOOL SortFileInMemory(LPTSTR FileName, HANDLE hFile, LPBYTE lpBuffer,
							LPSORT_TEMPLATE lpSortParameters, DWORD dwRecordCount, 
							DWORD dwFileSize, DWORD dwHeaderBytes, DWORD dwDirection)
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liHdrBytes;
	BOOL			bResult;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;

	liHdrBytes.QuadPart = 0;
	liHdrBytes.LowPart = dwHeaderBytes;

	// Read the file into memory. It is already positioned after any
	// header bytes in the file.
	//...........................
	bResult = ReadMyFile(FileName,hFile,lpBuffer,dwFileSize,&dwBytesRead,NULL);
	if (!bResult)
	{
		goto SortEnd;
	}
	// Sort the file in memory.
	//.........................
	ShellSort(lpBuffer,dwRecordCount,lpSortParameters,dwDirection);

	// Position the file pointer to point to the first record
	// in the file, and write the sorted buffer back to the file.
	//...........................................................
	li.QuadPart = SetMyFilePointer(FileName,hFile,liHdrBytes.QuadPart,FILE_BEGIN);
	if (li.QuadPart == -1)
	{
		goto SortEnd;
	}
	bResult = WriteMyFile(FileName,hFile,lpBuffer,dwFileSize,&dwBytesWritten,NULL);

	SortEnd:
	bResult = TRUE;
	return(bResult);
}

// Sort a file on disk because we do not have enough memory to
// read the whole file into memory and sort it there. Called
// from SortMyFile. Returns TRUE if successful, else FALSE.
//............................................................
BOOL SortFileOnDisk(LPTSTR FileName, HANDLE hFile,LPSORT_TEMPLATE lpSortParameters,
						  DWORD dwRecordCount, DWORD dwFileSize,DWORD dwHeaderBytes, 
						  DWORD dwDirection)
{
	LARGE_INTEGER	li;
	ULARGE_INTEGER	liIndexB;
	ULARGE_INTEGER	liIndexC;
	LPBYTE			lpBBuffer;
	LPBYTE			lpCBuffer;
	LPBYTE			lpRecordB;
	LPBYTE			lpRecordC;
	DWORD			dwTempEDX;
	DWORD			dwTempEBX;
	DWORD			dwCenter;
	DWORD			dwBoundry;
	DWORD			dwDupBoundry;
	DWORD			dwFlag;
	DWORD			dwRecordSize;
	BOOL			bRWResult;
	DWORD			dwBytesRW;
	int				iCompareResult;
	BOOL			bResult;
	BOOL			bSwapFlag;
	BYTE			Above;
	BYTE			Below;
	BYTE			Signed;

	// Setup some local variables.
	//............................
	liIndexB.QuadPart = 0;
	liIndexC.QuadPart = 0;
	bResult = FALSE;

	// Setup a local record size for the swapping.
	//............................................
	dwRecordSize = lpSortParameters->RECORD_SIZE;

	// Allocate memory for the B and C buffers equal to the
	// record length we have to sort.
	//.....................................................
	lpBBuffer = AllocateMemory(dwRecordSize);
	lpCBuffer = AllocateMemory(dwRecordSize);
	if (!lpBBuffer || !lpCBuffer)
	{
		goto SortEnd;
	}
	// If we have two or more records, sort them.
	//...........................................
	if (dwRecordCount >= 2)
	{
		__asm
		{
			// Center = record count / 2.
			//...........................
			mov		eax,dwRecordCount
			shr		eax,1
			mov		dwCenter,eax

			// Make sure - process low to high addresses.
			//...........................................
			cld		
		}
		// When dwCenter = 0 we are done with the sort.
		//.............................................
		while (dwCenter != 0)
		{
			// Boundry = record count - center.
			//.................................
			__asm
			{
				mov		eax,dwRecordCount
				sub		eax,dwCenter
				mov		dwBoundry,eax
			L1:	mov		dwFlag,0

				// liIndexB = beginning of file + header bytes.
				// liIndexC = header bytes + (center * size of record).
				//.....................................................
				mov		eax,dwHeaderBytes
				mov		liIndexB.LowPart,eax
				mov		liIndexC.LowPart,eax
				mov		eax,dwCenter
				mov		ecx,dwRecordSize;
				mul		ecx
				add		liIndexC.LowPart,eax
				adc		liIndexC.HighPart,edx
				mov		bSwapFlag,FALSE
				mov		eax,dwBoundry
				mov		dwDupBoundry,eax
			}
			while (dwDupBoundry != 0)
			{
				// Read the two records at file locations liIndexB
				// and liIndexC into their respective buffers.
				//................................................
				li.QuadPart = 0;
				li.QuadPart = SetMyFilePointer(FileName,hFile,liIndexB.QuadPart,FILE_BEGIN);
				if (li.QuadPart == -1)
				{
					goto SortEnd;
				}
				bRWResult = ReadMyFile(FileName,hFile,lpBBuffer,dwRecordSize,&dwBytesRW,NULL);
				if (!bRWResult)
				{
					goto SortEnd;
				}
				li.QuadPart = 0;
				li.QuadPart = SetMyFilePointer(FileName,hFile,liIndexC.QuadPart,FILE_BEGIN);
				if (li.QuadPart == -1)
				{
					goto SortEnd;
				}
				bRWResult = ReadMyFile(FileName,hFile,lpCBuffer,dwRecordSize,&dwBytesRW,NULL);
				if (!bRWResult)
				{
					goto SortEnd;
				}
				// Start sorting the records with the first set
				// of sort parameters.
				//.............................................
				__asm
				{
					mov		edx,lpSortParameters
					xor		ebx,ebx
					mov		dwTempEDX,edx
					mov		dwTempEBX,ebx
				}
				// Compare the two records in the files.
				//......................................
				while (TRUE)
				{
					__asm
					{
						mov		edx,dwTempEDX
						mov		ebx,dwTempEBX
						mov		esi,lpBBuffer
						mov		edi,lpCBuffer
						add		esi,dword ptr [edx][ebx].COMPARE_OFFSET
						add		edi,dword ptr [edx][ebx].COMPARE_OFFSET
						mov		lpRecordB,esi
						mov		lpRecordC,edi

						// Size of the data to compare. If bytes, the
						// number of bytes; if words, the number of words;
						// if dwords, the number of dwords.
						//................................................
						mov		ecx,dword ptr [edx][ebx].COMPARE_SIZE

						// See if we are doing a signed comparison.
						//.........................................
						btr		dword ptr [edx][ebx].TYPE_SORT,7
						setc	Signed

						// Setup the direction for the comparision.
						//.........................................
						cmp		dword ptr [edx][ebx].COMPARE_DIRECTION,BACKWARD
						jne		L2

						// Comparision is performed backwards - high address to low.
						//..........................................................
						std

						// Compare bytes.
						//...............
					L2:	cmp		dword ptr [edx][ebx].TYPE_SORT,SORT_BYTES
						jne		L3
						repe	cmpsb
						jmp		L5
						
						// Compare words.
						//...............
					L3:	cmp		dword ptr [edx][ebx].TYPE_SORT,SORT_WORDS
						jne		L4
						rep		cmpsw
						jmp		L5

						// Compare dwords.
						//................
					L4:	cmp		dword ptr [edx][ebx].TYPE_SORT,SORT_DWORDS
						jne		L7					// Default to sort strings.
						repe	cmpsd
						
						// Make sure - reset direction to low to high address.
						//....................................................
					L5:	cld			
						
						// Set the flags depending on if we sorted signed
						// fields or not.
						//...............................................
						pushfd
						cmp		Signed,1
						je		L6
						popfd
						seta	Above
						setb	Below
						jmp		L8
					L6:	popfd
						setg	Above
						setl	Below

						// Reset the signed field in the TYPE_SORT
						// parameter for the next record.
						//........................................
						bts		dword ptr [edx][ebx].TYPE_SORT,7
						jmp		L8

						// Save all of our registeres.
						//............................
					L7:	pushad
					}
					// Compare strings using user default settings.
					//.............................................
					iCompareResult = CompareString(LOCALE_USER_DEFAULT,NORM_IGNORECASE,
												   lpRecordB,-1,lpRecordC,-1);

					// Swap entries depending on the result of
					// the comparison and sort direction. The
					// entries will not be swaped if they are
					// equal.
					//........................................
					Above = 0;
					Below = 0;
					if (iCompareResult == CSTR_LESS_THAN)
					{
						Below = 1;
					}
					else if (iCompareResult == CSTR_GREATER_THAN)
					{
						Above = 1;
					}

					__asm
					{
						popad

						// Break if the fields are not equal.
						//...................................
						cmp		iCompareResult,CSTR_EQUAL
					L8:	jne		CheckSwap

						// Break if the fields are equal and we have
						// no more fields to sort on; else continue
						// sorting the record on the next field.
						//...........................................
						add		ebx,20		// Size of one sort structure.
						mov		dwTempEBX,ebx
						cmp		dword ptr [edx][ebx].TYPE_SORT,SORT_END
						je		CheckSwap
					}
				}	// while TRUE
				
				// See if we have to swap the records.
				//....................................
				CheckSwap:
				if (((dwDirection == ASCENDING) && Above) || 
				   ((dwDirection == DESCENDING) && Below))
				{	
					// Write the swapped entries back to their proper
					// place in the file. Write lpCBuffer to liIndexB
					// and lpBBuffer to liIndexC.
					//...............................................
					li.QuadPart = 0;
					li.QuadPart = SetMyFilePointer(FileName,hFile,liIndexB.QuadPart,
												   FILE_BEGIN);
					if (li.QuadPart == -1)
					{
						goto SortEnd;
					}
					bRWResult = WriteMyFile(FileName,hFile,lpCBuffer,dwRecordSize,&dwBytesRW,
											NULL);
					if (!bRWResult)
					{
						goto SortEnd;
					}
					li.QuadPart = 0;
					li.QuadPart = SetMyFilePointer(FileName,hFile,liIndexC.QuadPart,
											       FILE_BEGIN);
					if (li.QuadPart == -1)
					{
						goto SortEnd;
					}
					bRWResult = WriteMyFile(FileName,hFile,lpBBuffer,
											dwRecordSize,&dwBytesRW,NULL);
					if (!bRWResult)
					{
						goto SortEnd;
					}
					bSwapFlag = TRUE;
				}
				// Adjust file pointers for the next pair of records.
				//...................................................
				__asm
				{
					mov		eax,dwRecordSize
					add		liIndexB.LowPart,eax
					adc		liIndexB.HighPart,0
					add		liIndexC.LowPart,eax
					adc		liIndexC.HighPart,0
					inc		dwFlag
					dec		dwDupBoundry
				}
			}	// while dwDupBounder != 0

			// Determine boundries for the next round of sorts.
			//.................................................
			__asm
			{
				// If dwFlag - dwCenter is equal to, or less than 0,
				// we are done with this section. Setup a new center.
				//...................................................
				mov		eax,dwFlag
				sub		eax,dwCenter
				jbe		L9

				// If we had a swap make boundry = flag - center.
				//...............................................
				cmp		bSwapFlag,TRUE
				jne		L9

				// Go back and sort the new boundry area.
				//.......................................
				mov		dwBoundry,eax
				jmp		L1

				// We did not have a swap or dwFlag = dwCenter.
				// Setup a new center.
				//.............................................
			L9:	shr		dwCenter,1
			}
		}	// while dwCenter != 0
	}	// if dwRecordCount >= 2

	// Deallocate the memory for the two buffers.
	//...........................................
	bResult = DeallocateMemory(lpCBuffer);
	if (!bResult)
	{
		goto SortEnd;
	}
	// The last deallocate memory sets the final result of the
	// file sort.
	//........................................................
	bResult = DeallocateMemory(lpBBuffer);

	SortEnd:
	return(bResult);
}

// Convert a timestamp to its proper GMT date and time.
//.....................................................
VOID TimestampToDateTime(__int64 Timestamp, LPSYSTEMTIME lpst)
{
	LARGE_INTEGER	li;
	DWORD			dwJulianDate;
	DWORD			dwTimeRemainder;
	DWORD			dwHours2;
	DWORD			dwMinutes2;
	DWORD			dwSeconds2;

	// Setup our timestamp in the correct variable.
	//.............................................
	li.QuadPart = Timestamp;

	__asm
	{
		mov		dwJulianDate,JD_1_JAN_1970

		// First determine the number of days since 1 Jan 1970,
		// then fill in the date.
		//.....................................................
		mov		eax,li.LowPart
		mov		edx,li.HighPart
		mov		ecx,SECS_PER_DAY
		div		ecx
		mov		dwTimeRemainder,edx
		add		dwJulianDate,eax
	}
	JulianToDate(lpst,dwJulianDate);

	// Now calculate the day of the week.
	//...................................
	lpst->wDayOfWeek = DayOfWeek(dwJulianDate);

	// Now lets do the time.
	//......................
	__asm
	{
		mov		eax,dwTimeRemainder
		xor		edx,edx
		mov		ecx,SECS_PER_HOUR
		div		ecx
		mov		dwHours2,eax
		
		// Do the minutes and seconds.
		//............................
		mov		eax,edx
		xor		edx,edx
		mov		ecx,60
		div		ecx
		mov		dwMinutes2,eax
		mov		dwSeconds2,edx
	}
	// Store the time in the SYSTEMTIME structure.
	//............................................
	lpst->wHour = LOWORD(dwHours2);
	lpst->wMinute = LOWORD(dwMinutes2);
	lpst->wSecond = LOWORD(dwSeconds2);
	lpst->wMilliseconds = 0;
}

// Get the major and minor version number of comctl32.dll.
// Also the version of shell32.dll.
//........................................................
BOOL GetComCtlVersion(LPDWORD lpdwMajor, LPDWORD lpdwMinor)
{
	HINSTANCE   hComCtl;
	HINSTANCE	hShell32;
	HINSTANCE	hSlwapi;
	BOOL		bResult = TRUE;

	// Load the DLL.
	//..............
	hShell32 = LoadLibrary(TEXT("shell32.dll"));
	hComCtl = LoadLibrary(TEXT("comctl32.dll"));
	hSlwapi = LoadLibrary(TEXT("shlwapi.dll"));

	if(hSlwapi)
	{
		HRESULT           hr;
		DLLGETVERSIONPROC pDllGetVersion;
   
		// You must get this function explicitly because earlier 
		// versions of the DLL don't implement this function. That
		// makes the lack of implementation of the function a version 
		// marker in itself.
		//...........................................................
		pDllGetVersion = (DLLGETVERSIONPROC)GetProcAddress(hSlwapi,TEXT("DllGetVersion"));
   
		if(pDllGetVersion)
		{
			DLLVERSIONINFO    dvi;
      
			ZeroMemory(&dvi, sizeof(dvi));
			dvi.cbSize = sizeof(dvi);
   
			hr = (*pDllGetVersion)(&dvi);
      
			if(SUCCEEDED(hr))
			{
				dwSlwapiMajor = dvi.dwMajorVersion;
				dwSlwapiMinor = dvi.dwMinorVersion;
			}
		}
		else
		{
			// If GetProcAddress failed, then the DLL is a version
			// previous to the one shipped with IE 3.x.
			//....................................................
			dwSlwapiMajor = 4;
			dwSlwapiMinor = 0;
		}
		FreeLibrary(hSlwapi);
	}
	if(hShell32)
	{
		HRESULT           hr;
		DLLGETVERSIONPROC pDllGetVersion;
   
		// You must get this function explicitly because earlier 
		// versions of the DLL don't implement this function. That
		// makes the lack of implementation of the function a version 
		// marker in itself.
		//...........................................................
		pDllGetVersion = (DLLGETVERSIONPROC)GetProcAddress(hShell32,TEXT("DllGetVersion"));
   
		if(pDllGetVersion)
		{
			DLLVERSIONINFO    dvi;
      
			ZeroMemory(&dvi, sizeof(dvi));
			dvi.cbSize = sizeof(dvi);
   
			hr = (*pDllGetVersion)(&dvi);
      
			if(SUCCEEDED(hr))
			{
				dwShellMajor = dvi.dwMajorVersion;
				dwShellMinor = dvi.dwMinorVersion;
			}
		}
		else
		{
			// If GetProcAddress failed, then the DLL is a version
			// previous to the one shipped with IE 3.x.
			//....................................................
			dwShellMajor = 4;
			dwShellMinor = 0;
		}
		FreeLibrary(hShell32);
	}
	// Now do the comctl32.dll.
	//.........................
	if(hComCtl)
	{
		HRESULT           hr;
		DLLGETVERSIONPROC pDllGetVersion;
   
		// You must get this function explicitly because earlier 
		// versions of the DLL don't implement this function. That
		// makes the lack of implementation of the function a version 
		// marker in itself.
		//...........................................................
		pDllGetVersion = (DLLGETVERSIONPROC)GetProcAddress(hComCtl,TEXT("DllGetVersion"));
   
		if(pDllGetVersion)
		{
			DLLVERSIONINFO    dvi;
      
			ZeroMemory(&dvi, sizeof(dvi));
			dvi.cbSize = sizeof(dvi);
   
			hr = (*pDllGetVersion)(&dvi);
      
			if(SUCCEEDED(hr))
			{
				*lpdwMajor = dvi.dwMajorVersion;
				*lpdwMinor = dvi.dwMinorVersion;
			}
			else
			{
				bResult = FALSE;
			}
		}
		else
		{
			// If GetProcAddress failed, then the DLL is a version
			// previous to the one shipped with IE 3.x.
			//....................................................
			*lpdwMajor = 4;
			*lpdwMinor = 0;
		}
		FreeLibrary(hComCtl);
	}
	else
	{
		bResult = FALSE;
	}
	return(bResult);
}

// Search an area of memory for a designated string.
// Returns TRUE if a match is found, else FALSE.
//..................................................
BOOL SearchFor(LPBYTE lpString, DWORD dwStringLength, LPBYTE lpWhere, DWORD dwMaximumLength)
{
	BOOL	bResult = TRUE;

	if (dwMaximumLength < dwStringLength)
	{
		bResult = FALSE;
		goto SearchEnd;
	}
	__asm
	{
		mov		esi,lpString
		mov		edi,lpWhere
		mov		ecx,dwMaximumLength

		// Do not test past the end of the buffer.
		//........................................
		sub		ecx,dwStringLength
		inc		ecx

		// Perform the search.
		//....................
	  SearchStart:
		push	ecx
		push	esi
		push	edi
		mov		ecx,dwStringLength
		repe	cmpsb
		pop		edi
		pop		esi
		pop		ecx

		// We found a match.
		//..................
		jz		SearchEnd

		// Next place to start looking for the string.
		//............................................
		inc		edi
		dec		ecx
		jnz		SearchStart

		// No match found. Return FALSE.
		//..............................
		mov		bResult,FALSE
	}
	SearchEnd:

	__asm
	{
		mov		lpSearchEDI,edi
	}
	return(bResult);
}

// Display the TSC logo.
//......................
VOID DisplayTscLogo()
{
	HBITMAP			hBitMap;
	BITMAP			bm;
	HDC				hDc;
	HDC				hMemDc;
	RECT			rect;
	int				x;
	int				y;

	if (cfg.dwDisplayLogo)
	{
		if (!bLogo || GetUpdateRect(hMainWindow,&rect,FALSE))
		{
			// Load the bitmap into memory.
			//.............................
			hBitMap = LoadBitmap(hInst,"TSC_LOGO");

			// Get the bitmap information.
			//............................
			GetObject(hBitMap,sizeof(BITMAP),&bm);

			hDc = GetDC(hMainWindow);
			hMemDc = CreateCompatibleDC(hDc);
			SelectObject(hMemDc,hBitMap);

			// Center it in the client area.
			//..............................
			GetClientRect(hMainWindow,&rect);
			x = (rect.right - bm.bmWidth) / 2;
			y = (rect.bottom - bm.bmHeight) / 2;

			BitBlt(hDc,x,y,bm.bmWidth,bm.bmHeight,hMemDc,0,0,SRCCOPY);

			// Clean up after ourselves.
			//..........................
			DeleteDC(hMemDc);
			ReleaseDC(hMainWindow,hDc);
			DeleteObject(hBitMap);
		}
	}
}

// Get the file attributes for a specified file.
// Returns -1 for an error.
//..............................................
DWORD GetMyFileAttributes(LPBYTE lpFileName)
{
	DWORD		dwResult;
	int			iResult;

	// Stay in a loop until successful or told to quit.
	//.................................................
	while(TRUE)
	{
		dwResult = GetFileAttributes((LPCTSTR)lpFileName);
		if (dwResult == 0xffffffff)
		{
			iResult = ErrorProcedure((LPTSTR)lpFileName,IDS_GETFILEATTR,MB_RETRYCANCEL);
			if (iResult == IDRETRY)
			{
				iResult = 0;
				continue;
			}
		}
		break;
	}
	return(dwResult);
}

// Set the file attributes for a specified file.
//..............................................
BOOL SetMyFileAttributes(LPBYTE lpFileName, DWORD dwAttributes)
{
	BOOL		bResult;
	int			iResult;

	// Stay in a loop until successful or told to quit.
	//.................................................
	while(TRUE)
	{
		bResult = SetFileAttributes((LPCTSTR)lpFileName,dwAttributes);
		if (!bResult)
		{
			iResult = ErrorProcedure((LPTSTR)lpFileName,IDS_SETFILEATTR,MB_RETRYCANCEL);
			if (iResult == IDRETRY)
			{
				iResult = 0;
				continue;
			}
		}
		break;
	}
	return(bResult);
}

// Build or delete the crc32 table.
//.................................
BOOL Crc32Table(DWORD dwStatus)
{
	BOOL		bResult = FALSE;

	if (dwStatus == BUILD_TABLE)
	{
		if (!lpCrc32Table)
		{
			lpCrc32Table = AllocateMemory(1024);
			if (!lpCrc32Table)
			{
				goto Crc32End;
			}
			__asm
			{
				mov		edi,lpCrc32Table
				mov		esi,0
				mov		eax,0
				mov		ecx,256
			L1:	push	ecx
				push	eax
				mov		ecx,8
			L2:	test	eax,1
				jz		L3
				shr		eax,1
				xor		eax,Crc32Poly
				jmp		L4
			L3:	shr		eax,1
			L4:	dec		ecx
				jnz		L2
				mov		dword ptr [edi][esi*4],eax
				pop		eax
				inc		eax
				inc		esi
				pop		ecx
				dec		ecx
				jnz		L1
			}
		}
	}
	else if (dwStatus == DELETE_TABLE && lpCrc32Table)
	{
		bResult = DeallocateMemory(lpCrc32Table);
		lpCrc32Table = 0;
		if (!bResult)
		{
			goto Crc32End;
		}
	}
	bResult = TRUE;

	Crc32End:
	return(bResult);
}

// Setup the What's This popup menu.
//..................................
VOID SetupWhatsThis()
{
	mii.cbSize = sizeof(MENUITEMINFO);
	mii.fMask = MIIM_ID | MIIM_TYPE | MIIM_STATE;
	mii.fType = MFT_STRING;
	mii.fState = MFS_ENABLED;
	mii.wID = IDM_WHATSTHIS;
	mii.dwTypeData = (LPVOID)&szWhatsThis;
	mii.cch = sizeof(szWhatsThis);
}

// What's This popup menu and popup help for dialog box controls.
//...............................................................
VOID WhatsThis(HWND hDlg, HWND hControl, LPARAM lParam)
{
	HMENU		hMenu = 0;
	BOOL		bResult;
	int			x, y;
	RECT		rc;
	HWND		hHtmlHelpResult;

	if (hControl != hDlg)
	{
		hMenu = CreatePopupMenu();
		if (!hMenu)
		{
			return;
		}
		bResult = InsertMenuItem(hMenu,0,TRUE,&mii);
		if (!bResult)
		{
			return;
		}
		x = LOWORD(lParam);
		y = HIWORD(lParam);

		if (x == 0xffff)
		{
			GetWindowRect(hControl,&rc);
			x = rc.left + ((rc.right - rc.left) /2);
			y = rc.top + 5;
		}
		// Display the What's This? popup menu.
		//.....................................
		bResult = TrackPopupMenuEx(hMenu,TPM_LEFTALIGN | TPM_TOPALIGN | 
								   TPM_NONOTIFY | TPM_RIGHTBUTTON |
								   TPM_RETURNCMD,x,y,hDlg,NULL);
		if (bResult)
		{
			hHtmlHelpResult = HtmlHelp(hControl,lpContextHelp,HH_TP_HELP_CONTEXTMENU,
									  (DWORD)lpdwPadHelp);
			if (!hHtmlHelpResult)
			{
				MessageBoxProc(hDlg,IDS_PROGRAM_ERROR,IDS_NO_HTML_HELP,
							   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
			}
		}	
	}
	if (hMenu)
	{
		DestroyMenu(hMenu);
	}
}

// PopupHelp processes the WM_HELP messages for dialog boxes.
//...........................................................
VOID PopupHelp(HWND hDlg, LPARAM lParam)
{
	LPHELPINFO	lphi;
	HWND		hHtmlHelpResult;

	lphi = (LPHELPINFO)lParam;
	if (lphi->iContextType == HELPINFO_WINDOW)
	{
		hHtmlHelpResult = HtmlHelp(lphi->hItemHandle,lpContextHelp,HH_TP_HELP_WM_HELP,
								  (DWORD)lpdwPadHelp);
		if (!hHtmlHelpResult)
		{
			MessageBoxProc(hDlg,IDS_PROGRAM_ERROR,IDS_NO_HTML_HELP,
						   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		}
	}	
}

// Notify me sound function.
//..........................
VOID NotifyMe()
{
	if (cfg.dwPlaySounds)
	{
		PlaySound("NOTIFY_ME",hInst,SND_RESOURCE | SND_ASYNC);
	}
}

// Format a file name or string for displaying in an edit box. Look
// for & and make them double.
//.................................................................
VOID SetDlgItemTextFmt(HWND hDlg, int iControlID, LPCTSTR lpFileName)
{
	ZeroMemory(&szDisplayName,sizeof(szDisplayName));

	__asm
	{
		mov		esi,lpFileName
		mov		edi,offset szDisplayName

		// Go into a loop and look for & and make them double.
		//....................................................

	L1: lodsb
		stosb

		// Check for end of the string.
		//.............................
		cmp		al,00h
		je		L2

		// If the byte is an &, make it double.
		//.....................................
		cmp		al,'&'
		jne		L1
		mov		al,'&'
		stosb
		jmp		L1
	L2:
	}
	// Display the file name in the edit control.
	//...........................................
	SetDlgItemText(hDlg,iControlID,(LPCTSTR)&szDisplayName);
}

// Check to see if the current user is an administrator under
// Windows NT, 2000, XP.
//...........................................................
BOOL IsCurrentUserLocalAdministrator()
{
	BOOL   fReturn         = FALSE;
	DWORD  dwStatus;
	DWORD  dwAccessMask;
	DWORD  dwAccessDesired;
	DWORD  dwACLSize;
	DWORD  dwStructureSize = sizeof(PRIVILEGE_SET);
	PACL   pACL            = NULL;
	PSID   psidAdmin       = NULL;

	HANDLE hToken              = NULL;
	HANDLE hImpersonationToken = NULL;

	PRIVILEGE_SET   ps;
	GENERIC_MAPPING GenericMapping;

	PSECURITY_DESCRIPTOR     psdAdmin           = NULL;
	SID_IDENTIFIER_AUTHORITY SystemSidAuthority = SECURITY_NT_AUTHORITY;

	// Determine if the current thread is running as a user that is a member of
	// the local admins group. To do this, create a security descriptor that has a DACL 
	// which has an ACE that allows only local aministrators access. Then, call AccessCheck 
	// with the current thread's token and the security descriptor. It will say whether the
	// user could access an object if it had that security descriptor.  Note: you do not need 
	// to actually create the object. Just checking access against the security descriptor 
	// alone will be sufficient.
	//.......................................................................................
	const DWORD ACCESS_READ  = 1;
	const DWORD ACCESS_WRITE = 2;

	__try
	{
		// AccessCheck() requires an impersonation token.  We first get a primary token and
		// then create a duplicate impersonation token. The impersonation token is not
		// actually assigned to the thread, but is used in the call to AccessCheck. Thus,
		// this function itself never impersonates, but does use the identity of the thread.
		// If the thread was impersonating already, this function uses that impersonation
		// context.
		//..................................................................................
		if (!OpenThreadToken(GetCurrentThread(),TOKEN_DUPLICATE | TOKEN_QUERY,TRUE,&hToken))
		{
			if (GetLastError() != ERROR_NO_TOKEN)
			{
				__leave;
			}
			if (!OpenProcessToken(GetCurrentProcess(),TOKEN_DUPLICATE | TOKEN_QUERY,&hToken))
			{
				__leave;
			}
		}
		if (!DuplicateToken (hToken,SecurityImpersonation,&hImpersonationToken))
		{
			__leave;
		}
		// Create the binary representation of the well-known SID that represents the local
		// administrators group. Then create the security descriptor and DACL with an ACE
		// that allows only local admins access. After that, perform the access check. This
		// will determine whether the current user is a local admin.
		//.................................................................................
		if (!AllocateAndInitializeSid(&SystemSidAuthority,2,SECURITY_BUILTIN_DOMAIN_RID,
                                      DOMAIN_ALIAS_RID_ADMINS,0,0,0,0,0,0,&psidAdmin))
		{
			__leave;
		}
		psdAdmin = LocalAlloc(LPTR,SECURITY_DESCRIPTOR_MIN_LENGTH);
		if (psdAdmin == NULL)
		{
			__leave;
		}
		if (!InitializeSecurityDescriptor(psdAdmin,SECURITY_DESCRIPTOR_REVISION))
		{
			__leave;
		}
		// Compute size needed for the ACL.
		//.................................
		dwACLSize = sizeof(ACL) + sizeof(ACCESS_ALLOWED_ACE) + 
					GetLengthSid(psidAdmin) - sizeof(DWORD);

		pACL = (PACL)LocalAlloc(LPTR,dwACLSize);
		if (pACL == NULL)
		{
			__leave;
		}
		if (!InitializeAcl(pACL,dwACLSize,ACL_REVISION2))
		{
			__leave;
		}
		dwAccessMask= ACCESS_READ | ACCESS_WRITE;

		if (!AddAccessAllowedAce(pACL,ACL_REVISION2,dwAccessMask,psidAdmin))
		{
			__leave;
		}
		if (!SetSecurityDescriptorDacl(psdAdmin,TRUE,pACL,FALSE))
		{
			__leave;
		}

		// AccessCheck validates a security descriptor somewhat; set the group and owner
		// so that enough of the security descriptor is filled out to make AccessCheck 
		// happy.
		//..............................................................................
		SetSecurityDescriptorGroup(psdAdmin,psidAdmin,FALSE);
		SetSecurityDescriptorOwner(psdAdmin,psidAdmin,FALSE);

		if (!IsValidSecurityDescriptor(psdAdmin))
		{
			__leave;
		}
		dwAccessDesired = ACCESS_READ;

		// Initialize GenericMapping structure even though you do not use generic rights.
		//...............................................................................
		GenericMapping.GenericRead    = ACCESS_READ;
		GenericMapping.GenericWrite   = ACCESS_WRITE;
		GenericMapping.GenericExecute = 0;
		GenericMapping.GenericAll     = ACCESS_READ | ACCESS_WRITE;

		if (!AccessCheck(psdAdmin,hImpersonationToken,dwAccessDesired,
                         &GenericMapping,&ps,&dwStructureSize,&dwStatus,&fReturn))
		{
			fReturn = FALSE;
			__leave;
		}
	}
	__finally
	{
		// Clean up.
		//..........
		if (pACL) LocalFree(pACL);
		if (psdAdmin) LocalFree(psdAdmin);
		if (psidAdmin) FreeSid(psidAdmin);
		if (hImpersonationToken) CloseHandle (hImpersonationToken);
		if (hToken) CloseHandle (hToken);
	}
	return(fReturn);
}

// Read the cfg file into memory.
//...............................
BOOL ReadMyCfgFile()
{
	BOOL	bResult = FALSE;
	DWORD	dwBytesRead;
	HANDLE	hCfgFile = 0;

	hCfgFile = CreateMyFile((LPTSTR)&szCfgFile,GENERIC_READ,0,NULL,OPEN_EXISTING,
							 FILE_ATTRIBUTE_NORMAL,NULL);
	if (hCfgFile)
	{
		bResult = ReadMyFile((LPTSTR)&szCfgFile,hCfgFile,&cfg,sizeof(CONFIG),&dwBytesRead,
							  NULL);
		if (bResult)
		{
			bResult = CloseMyHandle((LPTSTR)&szCfgFile,hCfgFile);
		}
	}
	return(bResult);
}

// Write the cfg file to disk.
//............................
BOOL WriteMyCfgFile()
{
	BOOL	bResult = FALSE;
	HANDLE	hCfgFile = 0;
	DWORD	dwBytesWritten;
	BOOL	bRemoveFileName;

	// Remove the file name and backslash if it is there.
	//...................................................
	bRemoveFileName = SearchFor(TEXT("RandomBitsBin.rbb"),17,(LPBYTE)&cfg.RandomBitsFile,
								MAX_PATH);
	if (bRemoveFileName)
	{
		PathRemoveFileSpec((LPTSTR)&cfg.RandomBitsFile);
	}

	hCfgFile = CreateMyFile((LPTSTR)&szCfgFile,GENERIC_WRITE,0,NULL,OPEN_ALWAYS,
							 FILE_ATTRIBUTE_NORMAL,NULL);
	if (hCfgFile)
	{
		bResult = WriteMyFile((LPTSTR)&szCfgFile,hCfgFile,&cfg,sizeof(CONFIG),&dwBytesWritten,
							   NULL);
		if (bResult)
		{
			bResult = CloseMyHandle((LPTSTR)&szCfgFile,hCfgFile);
		}
	}
	// Add the file name back if we removed it.
	//.........................................
	if (bRemoveFileName)
	{
		PathAddBackslash((LPTSTR)&cfg.RandomBitsFile);
		StringCbCatEx((LPTSTR)&cfg.RandomBitsFile,MAX_PATH,
					   TEXT("RandomBitsBin.rbb"),NULL,NULL,dwStringSafeFlag);
	}
	return(bResult);
}
